// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Iniohandler.pas' rev: 10.00

#ifndef IniohandlerHPP
#define IniohandlerHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inantifreezebase.hpp>	// Pascal unit
#include <Inbuffer.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inexceptioncore.hpp>	// Pascal unit
#include <Inintercept.hpp>	// Pascal unit
#include <Instreamvcl.hpp>	// Pascal unit
#include <Inresourcestringscore.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Iniohandler
{
//-- type declarations -------------------------------------------------------
typedef TMetaClass* TInIOHandlerClass;

class DELPHICLASS TInIOHandler;
class PASCALIMPLEMENTATION TInIOHandler : public Incomponent::TInComponent 
{
	typedef Incomponent::TInComponent inherited;
	
protected:
	bool FClosedGracefully;
	AnsiString FDestination;
	AnsiString FHost;
	Inbuffer::TInBuffer* FInputBuffer;
	Inintercept::TIdConnectionIntercept* FIntercept;
	int FMaxCapturedLines;
	Inglobal::TIdMaxLineAction FMaxLineAction;
	int FMaxLineLength;
	bool FOpened;
	int FPort;
	bool FReadLnSplit;
	bool FReadLnTimedOut;
	int FReadTimeOut;
	Inbuffer::TInBuffer* FRecvBuffer;
	int FRecvBufferSize;
	int FSendBufferSize;
	Inbuffer::TInBuffer* FWriteBuffer;
	int FWriteBufferThreshhold;
	void __fastcall BufferRemoveNotify(System::TObject* ASender, int ABytes);
	virtual AnsiString __fastcall GetDestination();
	virtual void __fastcall InitComponent(void);
	void __fastcall InterceptReceive(Inglobal::TBytes &VBuffer);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall PerformCapture(System::TObject* ADest, /* out */ int &VLineCount, AnsiString ADelim, bool AIsRFCMessage);
	void __fastcall RaiseConnClosedGracefully(void);
	virtual void __fastcall SetDestination(AnsiString AValue);
	virtual void __fastcall SetHost(AnsiString AValue);
	virtual void __fastcall SetPort(int AValue);
	virtual void __fastcall SetIntercept(Inintercept::TIdConnectionIntercept* AValue);
	virtual int __fastcall ReadFromSource(bool ARaiseExceptionIfDisconnected = true, int ATimeout = 0xffffffff, bool ARaiseExceptionOnTimeout = true) = 0 ;
	
public:
	virtual void __fastcall AfterAccept(void);
	virtual bool __fastcall Connected(void);
	__fastcall virtual ~TInIOHandler(void);
	virtual void __fastcall CheckForDisconnect(bool ARaiseExceptionIfDisconnected = true, bool AIgnoreBuffer = false) = 0 ;
	virtual void __fastcall CheckForDataOnSource(int ATimeout = 0x0) = 0 ;
	virtual void __fastcall Close(void);
	virtual void __fastcall CloseGracefully(void);
	/*         class method */ static TInIOHandler* __fastcall MakeDefaultIOHandler(TMetaClass* vmt, Classes::TComponent* AOwner = (Classes::TComponent*)(0x0));
	/*         class method */ static TInIOHandler* __fastcall MakeIOHandler(TMetaClass* vmt, TMetaClass* ABaseType, Classes::TComponent* AOwner = (Classes::TComponent*)(0x0));
	/*         class method */ static void __fastcall RegisterIOHandler(TMetaClass* vmt);
	/*         class method */ static void __fastcall SetDefaultClass(TMetaClass* vmt);
	virtual AnsiString __fastcall WaitFor(AnsiString AString);
	virtual void __fastcall Write(Inglobal::TBytes ABuffer)/* overload */;
	virtual void __fastcall WriteDirect(Inglobal::TBytes ABuffer);
	virtual void __fastcall Open(void);
	virtual bool __fastcall Readable(int AMSec = 0xffffffff);
	virtual void __fastcall Write(AnsiString AOut)/* overload */;
	virtual void __fastcall WriteLn(AnsiString AOut = "");
	virtual void __fastcall Write(Classes::TStrings* AValue, bool AWriteLinesCount = false)/* overload */;
	void __fastcall Write(char AValue)/* overload */;
	void __fastcall Write(unsigned AValue, bool AConvert = true)/* overload */;
	void __fastcall Write(int AValue, bool AConvert = true)/* overload */;
	void __fastcall Write(short AValue, bool AConvert = true)/* overload */;
	void __fastcall Write(__int64 AValue, bool AConvert = true)/* overload */;
	virtual void __fastcall Write(Instreamvcl::TInStreamVCL* AStream, int ASize = 0x0, bool AWriteByteCount = false)/* overload */;
	virtual unsigned __fastcall WriteFile(AnsiString AFile, bool AEnableTransferFile = false);
	virtual AnsiString __fastcall AllData();
	virtual AnsiString __fastcall InputLn(AnsiString AMask = "", bool AEcho = true, int ATabWidth = 0x8, int AMaxLineLength = 0xffffffff);
	void __fastcall Capture(Classes::TStream* ADest)/* overload */;
	void __fastcall Capture(Classes::TStream* ADest, AnsiString ADelim, bool AIsRFCMessage = true)/* overload */;
	void __fastcall Capture(Classes::TStream* ADest, /* out */ int &VLineCount, AnsiString ADelim = ".", bool AIsRFCMessage = true)/* overload */;
	void __fastcall Capture(Classes::TStrings* ADest)/* overload */;
	void __fastcall Capture(Classes::TStrings* ADest, AnsiString ADelim, bool AIsRFCMessage = true)/* overload */;
	void __fastcall Capture(Classes::TStrings* ADest, /* out */ int &VLineCount, AnsiString ADelim = ".", bool AIsRFCMessage = true)/* overload */;
	virtual void __fastcall ReadBytes(Inglobal::TBytes &VBuffer, int AByteCount, bool AAppend = true);
	AnsiString __fastcall ReadLn()/* overload */;
	virtual AnsiString __fastcall ReadLn(AnsiString ATerminator, int ATimeout = 0xffffffff, int AMaxLineLength = 0xffffffff)/* overload */;
	virtual AnsiString __fastcall ReadLnWait(int AFailCount = 0x7fffffff);
	AnsiString __fastcall ReadLnSplit(bool &AWasSplit, AnsiString ATerminator = "\n", int ATimeout = 0xffffffff, int AMaxLineLength = 0xffffffff);
	char __fastcall ReadChar(void);
	AnsiString __fastcall ReadString(int ABytes);
	unsigned __fastcall ReadCardinal(bool AConvert = true);
	int __fastcall ReadInteger(bool AConvert = true);
	__int64 __fastcall ReadInt64(bool AConvert = true);
	short __fastcall ReadSmallInt(bool AConvert = true);
	virtual void __fastcall ReadStream(Instreamvcl::TInStreamVCL* AStream, int AByteCount = 0xffffffff, bool AReadUntilDisconnect = false);
	void __fastcall ReadStrings(Classes::TStrings* ADest, int AReadLinesCount = 0xffffffff);
	virtual void __fastcall WriteBufferCancel(void);
	virtual void __fastcall WriteBufferClear(void);
	virtual void __fastcall WriteBufferClose(void);
	void __fastcall WriteBufferFlush(void)/* overload */;
	virtual void __fastcall WriteBufferFlush(int AByteCount)/* overload */;
	void __fastcall WriteBufferOpen(void)/* overload */;
	virtual void __fastcall WriteBufferOpen(int AThreshhold)/* overload */;
	bool __fastcall WriteBufferingActive(void);
	bool __fastcall InputBufferIsEmpty(void);
	void __fastcall InputBufferToStream(Instreamvcl::TInStreamVCL* AStream, int AByteCount = 0xffffffff);
	AnsiString __fastcall InputBufferAsString();
	__property bool ClosedGracefully = {read=FClosedGracefully, nodefault};
	__property Inbuffer::TInBuffer* InputBuffer = {read=FInputBuffer};
	__property int MaxCapturedLines = {read=FMaxCapturedLines, write=FMaxCapturedLines, default=-1};
	__property bool Opened = {read=FOpened, nodefault};
	__property int ReadTimeout = {read=FReadTimeOut, write=FReadTimeOut, nodefault};
	__property bool ReadLnTimedout = {read=FReadLnTimedOut, nodefault};
	__property int WriteBufferThreshhold = {read=FWriteBufferThreshhold, nodefault};
	__property OnWork ;
	__property OnWorkBegin ;
	__property OnWorkEnd ;
	
__published:
	__property AnsiString Destination = {read=GetDestination, write=SetDestination};
	__property AnsiString Host = {read=FHost, write=SetHost};
	__property Inintercept::TIdConnectionIntercept* Intercept = {read=FIntercept, write=SetIntercept};
	__property int MaxLineLength = {read=FMaxLineLength, write=FMaxLineLength, default=16384};
	__property Inglobal::TIdMaxLineAction MaxLineAction = {read=FMaxLineAction, write=FMaxLineAction, nodefault};
	__property int Port = {read=FPort, write=SetPort, nodefault};
	__property int RecvBufferSize = {read=FRecvBufferSize, write=FRecvBufferSize, default=32768};
	__property int SendBufferSize = {read=FSendBufferSize, write=FSendBufferSize, default=32768};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInIOHandler(Classes::TComponent* AOwner)/* overload */ : Incomponent::TInComponent(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Word GRecvBufferSizeDefault = 0x8000;
static const Word GSendBufferSizeDefault = 0x8000;
static const Word IdMaxLineLengthDefault = 0x4000;
static const Shortint Id_IOHandler_MaxCapturedLines = -1;

}	/* namespace Iniohandler */
using namespace Iniohandler;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Iniohandler
